import os
import sys
sys.path.append(os.path.expanduser('~/projects'))
import numpy as np
import math
from args.mountain_game import parse_args
from util.mountain_game.trajectories import get_trajectories
from util.mountain_game.create_instance import get_optimizers, get_function
from util.mountain_game.transform import np2tensorlist
from drawer.heatmap_gif import heatmap_gif
import json

def main():
    args=parse_args()
    num_iterations = math.floor(args.real_time/args.dt)  # 迭代次数
    compression_ratio=max(1.0, math.floor(math.sqrt(args.real_time)/(args.dt*math.sqrt(args.fluidity*args.avg_loss_grad*args.watch_time)))) #大于等于1
    args.image_per_second=args.real_time/(args.watch_time*args.dt*compression_ratio)
    print(num_iterations)
    print(compression_ratio)
    print(args.image_per_second)

    # 将命名空间对象转换为字典
    args_dict = vars(args)
    args_dict = {k: v for k, v in args_dict.items() if k not in ["id","config","image_per_second"]}
    # 将字典转为 JSON 格式字符串
    json_output = json.dumps(args_dict, indent=4)
    # 打印 JSON 格式的字符串
    print(json_output)

    f=get_function(args)
    # 动态生成网格数据
    grid = [np.linspace(getattr(args, f'{dim}min'), getattr(args, f'{dim}max'), getattr(args, f'{dim}num')) for dim in ['x', 'y', 'z'][:len(args.start_point)]]
    # 创建网格并将其转换为张量
    mesh = np.meshgrid(*grid)
    tensor_inputs = np2tensorlist(*mesh)
    # 计算函数的输出
    result = f(*tensor_inputs).detach().numpy()
    optimizers=get_optimizers(args)
    if args.trajectory:
        trajectories=get_trajectories(optimizers,f, num_iterations, compression_ratio)
    if args.pic_type=="heatmap":
        if (args.traj_type=="trace_and_dynamics" or args.traj_type=="dynamics") and args.trajectory:     
            heatmap_gif(result, trajectories, args)
if __name__ == '__main__':
    main()
